<?php
namespace grUPN;

if (!defined('ABSPATH')) exit;

class LogicUPN
{
    public $bacsAccount;

    public function __construct()
    {
        $gateways = \WC_Payment_Gateways::instance();
		$availableGateways = [];

		$availableGateways = $gateways->get_available_payment_gateways();

        if (isset($availableGateways["bacs"])) {
            if (!grfreemium()->is_not_paying()) {
                add_action("woocommerce_email_after_order_table", [$this, "displayUPNOnEmails"], 10, 3);
                add_action("woocommerce_thankyou_bacs", [$this, "displayUPNOnOrderPage"], 10, 3);
            }

            $bacsAccounts = $availableGateways["bacs"]->account_details;
            $this->bacsAccount = (object) $bacsAccounts[0];

            add_action("woocommerce_order_item_add_action_buttons", [$this, "grupnAddSendUpnButton"], 10, 3);
        }
    }

    public function grupnAddSendUpnButton($order)
    {
		if ("bacs" === $order->get_payment_method()) {
			$nonce = wp_create_nonce('gr_send_upn_nonce');
			echo '<button type="button" class="button gr-send-upn-button" data-order-id="' . esc_attr($order->get_id()) . '" data-nonce="' . esc_attr($nonce) . '">' . esc_html__('Pošlji UPN stranki', 'gr-upn-payment-form') . '</button>';
		}
    }

    public function genUPN($order)
    {
        $png = (new UPN())
            ->setPayerName($order->get_formatted_billing_full_name())
            ->setPayerAddress($order->get_billing_address_1())
            ->setPayerPost(sprintf("%s %s", $order->get_billing_postcode(), $order->get_billing_city()))
            ->setReceiverName(get_option("gr_ime_prejemnika", $this->bacsAccount->account_name))
            ->setReceiverAddress(get_option("gr_ulica_prejemnika", WC()->countries->get_base_address()))
            ->setReceiverPost(sprintf("%s %s", get_option("gr_posta_prejemnika", WC()->countries->get_base_postcode()), get_option("gr_kraj_prejemnika", WC()->countries->get_base_city())))
            ->setReceiverIban(get_option("gr_iban_prejemnika", $this->bacsAccount->iban))
            ->setAmount($order->get_total())
            ->setCode(get_option("gr_koda_namena", $this->bacsAccount->sort_code))
            ->setReference(sprintf("%s %s", get_option("gr_referenca_prejemnika", "SI00"), $order->get_order_number()))
            ->setDueDate(new \DateTime($order->get_date_created()))
            ->setPurpose(sprintf("%s %s", get_option("gr_namen_placila", "Plačilo naročila "), $order->get_order_number()))
            ->png();

        return !empty($png) ? $png : null;
    }

    public function displayUPNOnOrderPage($orderId)
    {
        if (!$orderId) return;

        $order = wc_get_order($orderId);

        if ($order->get_payment_method() === "bacs") {
            $png = $this->genUPN($order);
            if ($png) {
                echo '<div class="gr-upn">';
				// Dynamically embedded image (QR code) - not from media library.
                echo '<img src="data:image/png;base64,' . esc_attr(base64_encode($png)) . '" alt="' . esc_attr__('UPN QR Code', 'gr-upn-payment-form') . '">';
                echo '</div>';
            }
        }
    }

    public function displayUPNOnEmails($order, $sentToAdmin, $plainText)
    {
        if (!$sentToAdmin && "bacs" === $order->get_payment_method()) {
            $png = $this->genUPN($order);
            $imageUrl = $this->saveUpnImage($png, $order->get_id());

            if ($imageUrl && get_option("gr_email_priponka")) {
                add_filter("woocommerce_email_attachments", function ($attachments, $object) use ($imageUrl, $order) {
                    if (!empty($imageUrl)) {
                        $attachments[] = wp_upload_dir()['path'] . '/gr-upn-order-' . $order->get_id() . '.png';
                    }
                    return $attachments;
                }, 10, 2);
            }

            if ($imageUrl && get_option("gr_email_vstavi_upn")) {
                echo '<div class="gr-upn" style="margin-top: 20px;">';
                if (get_option("gr_email_priponka")) {
                    $fileName = 'gr-upn-order-' . $order->get_id() . '.png';
					// Inline image via CID for email attachment - standard email HTML formatting.
                    echo '<img src="cid:' . esc_attr($fileName) . '" alt="' . esc_attr__('Univerzalni plačilni nalog (UPN) za plačilo naročila', 'gr-upn-payment-form') . '">';
                } else {
					// Outputting plugin-generated image (not WP attachment)
                    echo '<img src="' . esc_url($imageUrl) . '" alt="' . esc_attr__('UPN - univerzalni plačilni nalog za plačilo naročila', 'gr-upn-payment-form') . '">';
                }
                echo '</div>';
            }
        }
    }

    public function saveUpnImage($img, $orderId)
    {
        $filePath = wp_upload_dir()["path"] . "/gr-upn-order-" . $orderId . ".png";
        file_put_contents($filePath, $img);

        $imageUrl = $filePath;
        if (is_ssl()) {
            $imageUrl = str_replace("http://", "https://", $imageUrl);
        }

        return $imageUrl;
    }
}
