<?php
namespace grUPN;

if (!defined('ABSPATH')) exit;

class WC_Settings_UPN extends \WC_Settings_Page
{
    public function __construct()
    {
        $this->id = "upn_settings";
        $this->label = __("UPN Nastavitve", "gr-upn-payment-form");

        add_filter("woocommerce_settings_tabs_array", [$this, "add_settings_tab"], 50);
        add_action("woocommerce_settings_" . $this->id, [$this, "output"]);
        add_action("woocommerce_settings_save_" . $this->id, [$this, "save"]);
    }

    public function add_settings_tab($tabs)
    {
        $tabs[$this->id] = $this->label;
        return $tabs;
    }

    public function get_settings()
    {
        if (grfreemium()->is_not_paying()) {
            echo '<div class="notice notice-warning"><p>' .
                esc_html__('Imate omejitev generiranja UPN obrazcev na: ', 'gr-upn-payment-form') .
                '25. <a href="' . esc_url(grfreemium()->get_upgrade_url()) . '">' .
                esc_html__('Nagradite', 'gr-upn-payment-form') . '</a> ' .
                esc_html__('za neomejeno uporabo.', 'gr-upn-payment-form') .
                '</p></div>';
        }

		$gateways = \WC_Payment_Gateways::instance();
		$availableGateways = [];

		$availableGateways = $gateways->get_available_payment_gateways();
        if (!isset($availableGateways["bacs"])) {
            add_action("admin_notices", function () {
                echo '<div class="notice notice-error"><p>' .
                    esc_html__('Direct bank transfer payment option not set in WooCommerce.', 'gr-upn-payment-form') .
                    '</p></div>';
            });
            return [];
        }

        $bacs_account = (object) $availableGateways["bacs"]->account_details[0];

        $settings = [
            [
                "title" => __("UPN Nastavitve", "gr-upn-payment-form"),
                "type" => "title",
                "desc" => __("Nastavitve za UPN QR plačila.", "gr-upn-payment-form"),
                "id" => "upn_settings_options",
            ],
            [
                "title" => __("Namen plačila", "gr-upn-payment-form"),
                "id" => "gr_namen_placila",
                "type" => "text",
                "default" => "Plačilo naročila",
                "desc_tip" => true,
            ],
            [
                "title" => __("Koda namena", "gr-upn-payment-form"),
                "id" => "gr_koda_namena",
                "type" => "text",
                "default" => $bacs_account->sort_code,
                "desc_tip" => true,
            ],
            [
                "title" => __("IBAN prejemnika", "gr-upn-payment-form"),
                "id" => "gr_iban_prejemnika",
                "type" => "text",
                "default" => $bacs_account->iban,
                "desc_tip" => true,
            ],
            [
                "title" => __("Referenca prejemnika", "gr-upn-payment-form"),
                "id" => "gr_referenca_prejemnika",
                "type" => "text",
                "default" => "SI00",
                "desc_tip" => true,
            ],
            [
                "title" => __("Ime prejemnika", "gr-upn-payment-form"),
                "id" => "gr_ime_prejemnika",
                "type" => "text",
                "default" => $bacs_account->account_name,
                "desc_tip" => true,
            ],
            [
                "title" => __("Ulica prejemnika", "gr-upn-payment-form"),
                "id" => "gr_ulica_prejemnika",
                "type" => "text",
                "default" => WC()->countries->get_base_address(),
                "desc_tip" => true,
            ],
            [
                "title" => __("Kraj prejemnika", "gr-upn-payment-form"),
                "id" => "gr_kraj_prejemnika",
                "type" => "text",
                "default" => WC()->countries->get_base_city(),
                "desc_tip" => true,
            ],
            [
                "title" => __("Poštna številka prejemnika", "gr-upn-payment-form"),
                "id" => "gr_posta_prejemnika",
                "type" => "text",
                "default" => WC()->countries->get_base_postcode(),
                "desc_tip" => true,
            ],
            [
                "title" => __("Dodaj UPN v email priponko (PRO)", "gr-upn-payment-form"),
                "id" => "gr_email_priponka",
                "type" => "checkbox",
                "default" => true,
                "desc_tip" => true,
                "custom_attributes" => grfreemium()->is_not_paying() ? ["disabled" => "disabled"] : [],
            ],
            [
                "title" => __("Dodaj UPN kot sliko v email sporočilo (PRO)", "gr-upn-payment-form"),
                "id" => "gr_email_vstavi_upn",
                "type" => "checkbox",
                "default" => true,
                "desc_tip" => true,
                "desc" => __("Če email blokira vaše slike v sporočilu poskusite dodati UPN tudi v priponko", "gr-upn-payment-form"),
                "custom_attributes" => grfreemium()->is_not_paying() ? ["disabled" => "disabled"] : [],
            ],
            [
                "type" => "sectionend",
                "id" => "upn_settings_options",
            ],
        ];

        return apply_filters("woocommerce_get_settings_" . $this->id, $settings);
    }
}
